<?php
require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../vendor/phpmailer/src/PHPMailer.php";
require_once __DIR__ . "/../vendor/phpmailer/src/SMTP.php";
require_once __DIR__ . "/../vendor/phpmailer/src/Exception.php";

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

function sendReminderEmail($to, $subject, $body){
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'yourgmail@gmail.com';   // replace
        $mail->Password   = 'your-app-password';     // replace with Gmail App Password
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        $mail->setFrom('yourgmail@gmail.com', 'Finmart Reminders');
        $mail->addAddress($to);

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = nl2br($body);

        $mail->send();
        echo "Email sent to $to\n";
    } catch (Exception $e) {
        echo "Email error ({$to}): {$mail->ErrorInfo}\n";
    }
}

$daysAhead = 7;
$today = date("Y-m-d");
$limitDate = date("Y-m-d", strtotime("+$daysAhead days"));

$sql = "SELECT c.name, c.email, c.phone, p.renewal_date, pr.product_name 
        FROM policies p
        JOIN customers c ON p.customer_id=c.id
        JOIN products pr ON p.product_id=pr.id
        WHERE p.renewal_date <= '$limitDate'";
$result = $conn->query($sql);

while($row = $result->fetch_assoc()){
    $custName = $row['name'];
    $email    = $row['email'];
    $phone    = $row['phone'];
    $date     = $row['renewal_date'];
    $product  = $row['product_name'];

    $daysLeft = (strtotime($date) - strtotime($today)) / 86400;

    if($daysLeft < 0){
        $status = "OVERDUE";
    } elseif($daysLeft <= 7){
        $status = "Due in $daysLeft days";
    } else {
        continue;
    }

    $subject = "Policy Renewal Reminder: $product";
    $message = "Dear $custName,\n\nYour $product policy is $status.\nRenewal date: $date.\n\nRegards,\nFinmart Team";

    if(!empty($email)){
        sendReminderEmail($email, $subject, $message);
    }

    $waMessage = urlencode("Hello $custName, your $product policy is $status. Renewal date: $date.");
    // Example API call (stub):
    // file_get_contents("https://graph.facebook.com/v17.0/YOUR_PHONE_NUMBER_ID/messages?access_token=YOUR_TOKEN&to=$phone&text=$waMessage");
    echo "WhatsApp reminder prepared for $phone\n";
}
?>